/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.network.packet;

import dev.toma.gunsrpg.common.capability.PlayerData;
import dev.toma.gunsrpg.common.tileentity.SkilledWorkbenchTileEntity;
import dev.toma.gunsrpg.network.AbstractNetworkPacket;
import dev.toma.gunsrpg.resource.crafting.OutputModifier;
import dev.toma.gunsrpg.resource.crafting.SkilledRecipe;
import dev.toma.gunsrpg.util.ModUtils;
import java.util.Optional;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class C2S_RequestSkilledCraftPacket
extends AbstractNetworkPacket<C2S_RequestSkilledCraftPacket> {
    private final BlockPos pos;
    private final boolean shiftKey;
    private SkilledRecipe<?> lastRecipe;

    public C2S_RequestSkilledCraftPacket() {
        this(null, false);
    }

    public C2S_RequestSkilledCraftPacket(BlockPos pos, boolean shiftKey) {
        this.pos = pos;
        this.shiftKey = shiftKey;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_179255_a(this.pos);
        buffer.writeBoolean(this.shiftKey);
    }

    @Override
    public C2S_RequestSkilledCraftPacket decode(PacketBuffer buffer) {
        return new C2S_RequestSkilledCraftPacket(buffer.func_179259_c(), buffer.readBoolean());
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        TileEntity tileEntity;
        ServerPlayerEntity player = context.getSender();
        World world = player.field_70170_p;
        if (this.pos != null && world.func_195588_v(this.pos) && (tileEntity = world.func_175625_s(this.pos)) instanceof SkilledWorkbenchTileEntity) {
            SkilledWorkbenchTileEntity inventoryTileEntity = (SkilledWorkbenchTileEntity)tileEntity;
            if (this.shiftKey) {
                while (this.tryCraft(world, inventoryTileEntity, (PlayerEntity)player)) {
                }
            } else {
                this.tryCraft(world, inventoryTileEntity, (PlayerEntity)player);
            }
        }
    }

    private <T extends SkilledWorkbenchTileEntity> boolean tryCraft(World world, T inventory, PlayerEntity player) {
        SkilledRecipe recipe;
        IRecipeType type;
        RecipeManager manager = world.func_199532_z();
        Optional optional = manager.func_215371_a(type = inventory.getRecipeType(), inventory, world);
        if (optional.isPresent() && (recipe = (SkilledRecipe)optional.orElseThrow(IllegalStateException::new)).canCraft(player)) {
            if (this.lastRecipe != null && this.lastRecipe != recipe) {
                return false;
            }
            this.lastRecipe = recipe;
            this.consumeIngredients(inventory);
            ItemStack result = recipe.assemble(inventory);
            OutputModifier modifier = recipe.getOutputModifier();
            if (modifier != null) {
                modifier.applyRaw(result, PlayerData.getUnsafe(player).getAttributes());
            }
            ModUtils.addItem(player, result);
            ItemStack returningItem = recipe.getReturningItem();
            if (!returningItem.func_190926_b()) {
                ModUtils.addItem(player, returningItem.func_77946_l());
            }
            return true;
        }
        return false;
    }

    private void consumeIngredients(IInventory inventory) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            stack.func_190918_g(1);
        }
    }
}

